/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.UpgradeScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GetBackupLocationScreen
extends UpgradeScreen
implements ActionListener {
    private final String btnCancelCmd = "CANCEL";
    private final String btnBrowseCmd = "BROWSE";
    private final String btnSkipBackupCmd = "SKIP_BAK";
    private final String btnNextCmd = "NEXT";
    private JTextField m_txtFilePath;
    private JFileChooser m_fChooser;
    private File m_currentDir = new File("Backup");

    public GetBackupLocationScreen(String string, AutoUpdateGUI autoUpdateGUI) {
        super(string, autoUpdateGUI);
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying PCMCIA Genstats Window");
        super.finalize();
        this.m_fChooser = null;
        this.m_txtFilePath = null;
        this.m_currentDir = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        JLabel jLabel = new JLabel("Please Specify the Backup Location on this Computer.");
        if (!this.m_currentDir.exists()) {
            this.m_currentDir.mkdirs();
        }
        this.m_fChooser = new JFileChooser();
        this.m_fChooser.setDialogType(0);
        this.m_fChooser.setCurrentDirectory(this.m_currentDir);
        this.m_fChooser.setDialogTitle("Select The Backup Directory");
        this.m_fChooser.setFileSelectionMode(1);
        this.m_fChooser.setAcceptAllFileFilterUsed(false);
        this.m_fChooser.setMultiSelectionEnabled(false);
        this.m_fChooser.setToolTipText("Enter the Backup Directory on this Computer");
        this.m_fChooser.requestFocusInWindow();
        JLabel jLabel2 = new JLabel("Backup Directory: ");
        this.m_txtFilePath = new JTextField(30);
        this.m_txtFilePath.setToolTipText("Specify the Backup Directory Path");
        try {
            this.m_txtFilePath.setText(this.m_currentDir.getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_txtFilePath.requestFocusInWindow();
        jLabel2.setLabelFor(this.m_txtFilePath);
        this.m_txtFilePath.addFocusListener(this);
        this.m_txtFilePath.setPreferredSize(new Dimension(500, 50));
        JButton jButton = new JButton("Browse...");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('B');
        jButton.setActionCommand("BROWSE");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('C');
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(actionListener);
        JButton jButton3 = new JButton("Skip Backup");
        jButton3.setVerticalTextPosition(0);
        jButton3.setHorizontalTextPosition(10);
        jButton3.setMnemonic('P');
        jButton3.setDefaultCapable(true);
        jButton3.setActionCommand("SKIP_BAK");
        jButton3.addActionListener(actionListener);
        JButton jButton4 = new JButton("Next >>");
        jButton4.setVerticalTextPosition(0);
        jButton4.setHorizontalTextPosition(10);
        jButton4.setMnemonic('N');
        jButton4.setDefaultCapable(true);
        jButton4.setActionCommand("NEXT");
        jButton4.addActionListener(actionListener);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 4;
        int n2 = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(80, 0, n, 4);
        gridBagConstraints.anchor = 25;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        gridBagConstraints.anchor = 25;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        int n3 = 90;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 0, n3, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtFilePath, gridBagConstraints);
        jPanel.add(this.m_txtFilePath);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 2, n3, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel2.add(jButton4);
        JPanel jPanel3 = new JPanel();
        super.setLogo(jPanel3);
        container.add((Component)jPanel3, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "Last");
        container.validate();
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if (this.btnNextCmd.equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.m_currentDir = new File(this.m_txtFilePath.getText());
            if (!this.m_currentDir.exists()) {
                this.m_currentDir.mkdir();
            }
            File[] fileArray = this.m_currentDir.listFiles();
            int n3 = -1;
            if (fileArray.length > 0) {
                Object[] objectArray = new Object[]{"Yes, Select Another Backup Location", "No, Continue with Upgrade", "Cancel Upgrade"};
                n3 = JOptionPane.showOptionDialog(super.getJFrame(), "The selected backup directory is not empty.\nIf you choose to continue with the selected backup directory, the existing Backup directory will be overwritten.\n\nDo you wish to select another backup directory?\n\n", "Backup Directory Not Empty", 1, 3, null, objectArray, objectArray[0]);
                switch (n3) {
                    case 0: {
                        n2 = n;
                        System.out.println("User will select new directory: ID=" + n2);
                        break;
                    }
                    case 1: {
                        System.out.println("User will continue with the Selected Backup Dir");
                        try {
                            device88X.deleteFolder(this.m_txtFilePath.getText(), null, null);
                        }
                        catch (IOException iOException) {
                            System.err.println("Error Clearing Backup Folder");
                        }
                        n2 = this.nextScreen(device88X);
                        device88X.setSkipBackupFlag(false);
                        device88X.setBackupDir(this.m_currentDir.getAbsolutePath());
                        System.out.println("Backup Dir: " + device88X.getBackupDir());
                        break;
                    }
                    case 2: {
                        System.out.println("Exiting");
                        System.exit(0);
                    }
                }
            } else {
                n2 = this.nextScreen(device88X);
                device88X.setSkipBackupFlag(false);
                device88X.setBackupDir(this.m_currentDir.getAbsolutePath());
                System.out.println("Backup Dir: " + device88X.getBackupDir());
            }
        } else if (this.btnSkipBackupCmd.equalsIgnoreCase(actionEvent.getActionCommand())) {
            device88X.setSkipBackupFlag(true);
            device88X.setBackupDir(null);
            System.out.println("Backup Skipped");
            n2 = this.nextScreen(device88X);
        }
        System.out.println("Next State " + n2);
        return n2;
    }

    private int nextScreen(Device88X device88X) {
        int n = device88X.isUsePCMCIA() ? 4 : 2;
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if ("BROWSE".equals(actionEvent.getActionCommand()) && (n = this.m_fChooser.showDialog(super.getJFrame(), "Select")) == 0) {
            File file;
            this.m_currentDir = file = this.m_fChooser.getSelectedFile();
            this.m_txtFilePath.setText(file.getPath().toString());
        }
    }
}

